/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanTool;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.SourceStat;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomHist;
import cds.tools.FastMath;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.OutputStream;

public class Position
extends Obj {
    static final int DS = 4;
    static final int DDS = 8;
    static final int HF = Aladin.SIZE;
    static final Font DF = Aladin.BOLD;
    protected double x;
    protected double y;
    protected double[] xv;
    protected double[] yv;
    static final int MAXMEDIANE = 100;
    static final int STATDY = 13;
    static final int HAUTSTAT = 117;
    static final int LARGSTAT = 150;

    protected void createCacheXYVP() {
        this.createCacheXYVP(this.plan == null ? 16 : this.plan.aladin.view.getNbView());
    }

    protected void createCacheXYVP(int dim) {
        if (dim == 0) {
            return;
        }
        this.xv = new double[dim];
        this.yv = new double[dim];
    }

    public Position() {
    }

    protected Position(Plan plan) {
        this.plan = plan;
        this.createCacheXYVP();
    }

    protected Position(Plan plan, ViewSimple v, double x, double y, double raj, double dej, int methode, String id) {
        this.id = id;
        this.plan = plan;
        this.createCacheXYVP();
        if ((methode & 1) != 0) {
            if (v != null) {
                this.xv[v.n] = x;
                this.yv[v.n] = y;
            }
            if (v == null || v.pref == null || !Projection.isOk(v.getProj())) {
                this.x = x;
                this.y = v == null ? y : (double)v.getPRefDimension().height - y;
            } else if ((methode & 4) != 0) {
                this.setCoord(v);
            }
        }
        if ((methode & 2) != 0) {
            this.raj = raj;
            this.dej = dej;
            if ((methode & 8) != 0) {
                try {
                    this.projection(v);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected Position(Plan plan, String id) {
        this.id = id;
        this.plan = plan;
        this.createCacheXYVP();
    }

    public String getLocalisation() {
        String s = this.plan.aladin.localisation.getLocalisation(this);
        if (s == null) {
            return "null,null";
        }
        s = s.replace(' ', ',');
        return s;
    }

    protected void syncPos(ViewSimple vs, ViewSimple vt) {
        this.xv[vt.n] = this.xv[vs.n];
        this.yv[vt.n] = this.yv[vs.n];
    }

    protected boolean inTime(ViewSimple v) {
        if (!this.plan.isTime()) {
            return true;
        }
        return v.inTime(this.jdtime);
    }

    protected void setWithLabel(boolean withLabel) {
        this.flags = withLabel ? (byte)(this.flags | 8) : (byte)(this.flags & 0xFFFFFFF7);
    }

    protected final void setWithStat(boolean withStat) {
        this.flags = withStat ? (byte)(this.flags | 0x20) : (byte)(this.flags & 0xFFFFFFDF);
    }

    protected final void setLocked(boolean movable) {
        this.flags = movable ? (byte)(this.flags | 0x40) : (byte)(this.flags & 0xFFFFFFBF);
    }

    protected boolean isWithLabel() {
        return (this.flags & 8) != 0;
    }

    protected final boolean isWithStat() {
        return (this.flags & 0x20) != 0;
    }

    protected final boolean isLocked() {
        return (this.flags & 0x40) != 0;
    }

    protected void setCoord(ViewSimple v) {
        Coord c = new Coord();
        boolean ok = false;
        Projection proj = v.getProj();
        if (Projection.isOk(proj)) {
            c.x = this.xv[v.n];
            c.y = this.yv[v.n];
            proj.getCoord(c);
            this.raj = c.al;
            this.dej = c.del;
            ok = true;
        }
        if (!ok && this.plan instanceof PlanTool) {
            ((PlanTool)this.plan).setXYorig(true);
        }
        if (ok) {
            View view = this.plan.aladin.view;
            int m = view.getNbView();
            for (int i = 0; i < m; ++i) {
                ViewSimple vx = view.viewSimple[i];
                if (vx == v || vx.isFree()) continue;
                this.projection(vx);
            }
        }
    }

    protected void setCoord(ViewSimple v, Projection proj) {
        Coord c = new Coord();
        c.x = this.xv[v.n];
        c.y = this.yv[v.n];
        proj.getCoord(c);
        this.raj = c.al;
        this.dej = c.del;
    }

    protected void setXY(Projection proj) {
        Coord c = new Coord();
        c.al = this.raj;
        c.del = this.dej;
        proj.getXY(c);
        if (!Double.isNaN(c.x)) {
            this.x = (double)Math.round(c.x * 1000.0) / 1000.0;
            this.y = proj.r1 - (double)Math.round(c.y * 1000.0) / 1000.0;
        }
    }

    protected void setXYTan(double x, double y) {
        this.x = x;
        this.y = y;
    }

    protected void setXYTan(Coord center) {
        this.x = Math.toRadians(Math.cos(Math.toRadians(center.del)) * (this.raj - center.al));
        this.y = Math.toRadians(this.dej - center.del);
    }

    @Override
    protected void projection(ViewSimple v) {
        Projection proj;
        Coord c = new Coord();
        if (this.plan != null && this.plan.hasNoPos) {
            return;
        }
        if (this.plan != null && this.plan.hasXYorig || !Projection.isOk(proj = v.getProj())) {
            this.xv[v.n] = this.x - 0.5;
            this.yv[v.n] = (double)v.getPRefDimension().height - this.y + 0.5;
        } else {
            if (this.raj == Double.NaN && this.xv[v.n] != 0.0) {
                this.setCoord(v, proj);
            }
            c.al = this.raj;
            c.del = this.dej;
            proj.getXY(c);
            this.xv[v.n] = c.x;
            this.yv[v.n] = c.y;
        }
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
        this.setPosition1(v, x, y);
    }

    protected void setPosition1(ViewSimple v, double x, double y) {
        if (this.raj == Double.NaN) {
            this.x = x;
            this.y = (double)v.getPRefDimension().height - y;
        }
        this.xv[v.n] = x;
        this.yv[v.n] = y;
        this.setCoord(v);
    }

    @Override
    protected void deltaPosition(ViewSimple v, double dx, double dy) {
        this.deltaPosition1(v, dx, dy);
    }

    protected void deltaPosition1(ViewSimple v, double dx, double dy) {
        if (this.raj == Double.NaN) {
            this.x += dx;
            this.y -= dy;
        }
        int n = v.n;
        this.xv[n] = this.xv[n] + dx;
        int n2 = v.n;
        this.yv[n2] = this.yv[n2] + dy;
        this.setCoord(v);
    }

    @Override
    protected void deltaRaDec(double dra, double dde) {
        this.deltaRaDec1(dra, dde);
    }

    protected void deltaRaDec1(double dra, double dde) {
        this.raj += dra;
        this.dej += dde;
        View view = this.plan.aladin.view;
        int m = view.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = view.viewSimple[i];
            if (v.isFree()) continue;
            this.projection(v);
        }
    }

    protected void rotatePosition(ViewSimple v, double theta, double x0, double y0) {
        double x = this.xv[v.n] - x0;
        double y = this.yv[v.n] - y0;
        double cost = FastMath.cos(theta);
        double sint = FastMath.sin(theta);
        this.xv[v.n] = x0 + x * cost - y * sint;
        this.yv[v.n] = y0 + x * sint + y * cost;
        this.setCoord(v);
    }

    @Override
    protected void setText(String id) {
        this.id = id;
    }

    @Override
    protected void switchSelect() {
        this.setSelect(!this.isSelected());
    }

    @Override
    protected void setVisibleGenerique(boolean visible) {
        this.setVisible(visible);
    }

    @Override
    protected Point getViewCoord(ViewSimple v, int dw, int dh) {
        if (Double.isNaN(this.xv[v.n])) {
            return null;
        }
        return v.getViewCoordWithMarge(null, this.xv[v.n], this.yv[v.n], dw, dh);
    }

    protected PointD getViewCoordDouble(ViewSimple v, int dw, int dh) {
        if (Double.isNaN(this.xv[v.n])) {
            return null;
        }
        return v.getViewCoordDoubleWithMarge(null, this.xv[v.n], this.yv[v.n], dw, dh);
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        return this.inBout(v, x, y);
    }

    @Override
    protected boolean inBout(ViewSimple v, double x, double y) {
        PointD p = v.getViewCoordDble(x, y);
        PointD p1 = v.getViewCoordDble(this.xv[v.n], this.yv[v.n]);
        double d = this.mouseDist(v);
        return p1.x * p1.x + p.x * p.y < d * d;
    }

    @Override
    protected boolean in(ViewSimple v, double x, double y) {
        return this.inside(v, x, y);
    }

    protected boolean inRectangle(ViewSimple v, RectangleD r) {
        return r.contains(this.xv[v.n], this.yv[v.n]);
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        Point p = this.getViewCoord(v, 0, 0);
        if (p == null) {
            return clip;
        }
        if (this.isSelected()) {
            return Position.unionRect(clip, p.x - 4, p.y - 4, 9, 9);
        }
        return Position.unionRect(clip, p.x, p.y, 1, 1);
    }

    @Override
    protected void info(Aladin aladin) {
    }

    @Override
    protected void status(Aladin aladin) {
        aladin.status.setText(this.id);
    }

    @Override
    protected void writeLink(OutputStream o, ViewSimple v) throws Exception {
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        if (!this.inTime(v)) {
            return false;
        }
        Point p = this.getViewCoord(v, 0, 0);
        if (p == null) {
            return false;
        }
        g.setColor(this.plan.c);
        p.x += dx;
        p.y += dy;
        g.drawLine(p.x, p.y, 1 + dx, 1 + dy);
        if (this.isSelected()) {
            g.setColor(Color.green);
            this.drawSelect(g, v);
        }
        return true;
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
        this.drawSelect(g, this.getClip(v));
    }

    protected void drawSelect(Graphics g, Rectangle r) {
        int xc = 0;
        int yc = 0;
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    xc = r.x;
                    yc = r.y + r.height - 4 - 1;
                    break;
                }
                case 1: {
                    xc = r.x;
                    yc = r.y;
                    break;
                }
                case 2: {
                    xc = r.x + r.width - 4 - 1;
                    yc = r.y;
                    break;
                }
                case 3: {
                    xc = r.x + r.width - 4 - 1;
                    yc = r.y + r.height - 4 - 1;
                }
            }
            this.drawPoignee(g, xc, yc);
        }
    }

    protected void drawPoignee(Graphics g, int xc, int yc) {
        g.setColor(Color.green);
        g.fillRect(xc + 1, yc + 1, 4, 4);
        g.setColor(Color.black);
        g.drawRect(xc, yc, 4, 4);
    }

    @Override
    protected boolean cutOn() {
        return false;
    }

    protected void histOn() {
        this.plan.aladin.calque.zoom.zoomView.activeHistPixel(this.id);
    }

    protected void statPixel(Graphics g, double pix, double ra, double dec, ViewSimple v, ZoomHist.HistItem onMouse) {
        Point p;
        Coord coo = new Coord(ra, dec);
        v.getProj().getXY(coo);
        Color col = g.getColor();
        double zoom = v.getZoom();
        if (g != null && onMouse != null && onMouse.contains(pix) && (p = v.getViewCoord(coo.x, coo.y)) != null) {
            g.setColor(Color.cyan);
            int z1 = (int)zoom;
            if (z1 < 1) {
                z1 = 2;
            }
            g.fillRect(p.x - z1 / 2, p.y - z1 / 2, z1, z1);
        }
        if (zoom > 2.0) {
            p = v.getViewCoord(coo.x, coo.y);
            if (!Double.isNaN(pix)) {
                g.setColor(col);
                if (zoom > 4.0) {
                    Util.fillCircle5(g, p.x, p.y);
                } else {
                    Util.fillCircle2(g, p.x, p.y);
                }
            }
        }
        g.setColor(col);
    }

    protected void statPixelBG(Graphics g, double pix, double ra, double dec, ViewSimple v, ZoomHist.HistItem onMouse) {
        Point p;
        Coord coo = new Coord(ra, dec);
        v.getProj().getXY(coo);
        Color col = g.getColor();
        double pixelSize = (double)v.rv.height / (v.getTailleDE() / ((PlanBG)v.pref).getPixelResolution()) / Math.sqrt(2.0);
        if (g != null && onMouse != null && onMouse.contains(pix) && (p = v.getViewCoord(coo.x, coo.y)) != null) {
            g.setColor(Color.cyan);
            int z1 = (int)pixelSize;
            if (z1 < 1) {
                z1 = 2;
            }
            Polygon pol = new Polygon(new int[]{p.x, p.x + z1, p.x, p.x - z1}, new int[]{p.y - z1, p.y, p.y + z1, p.y}, 4);
            g.fillPolygon(pol);
        }
        if (pixelSize > 4.0) {
            p = v.getViewCoord(coo.x, coo.y);
            if (!Double.isNaN(pix)) {
                g.setColor(col);
                if (pixelSize > 8.0) {
                    Util.fillCircle5(g, p.x, p.y);
                } else {
                    Util.fillCircle2(g, p.x, p.y);
                }
            }
        }
        g.setColor(col);
    }

    protected boolean statCompute(Graphics g, ViewSimple v, int z) {
        return false;
    }

    protected Rectangle getStatPosition(ViewSimple v) {
        return null;
    }

    protected void statDraw(Graphics g, ViewSimple v, int xvOrig, int yvOrig, int xvLabel, int yvLabel) {
        if (!v.flagPhotometry || !v.pref.hasAvailablePixels() || v.pref instanceof PlanImageRGB) {
            return;
        }
        int z = -1;
        if (v.pref.isCube()) {
            z = v.cubeControl.getCurrentFrameIndex();
        }
        double[] stats = null;
        try {
            stats = this.getStatistics(v.pref);
            if (stats == null || stats[0] == 0.0 || !this.statCompute(g, v, z)) {
                return;
            }
        }
        catch (Exception e) {
            return;
        }
        String cnt = Util.myRound(stats[0]);
        String sum = Util.myRound(stats[1]);
        String avg = Util.myRound(stats[1] / stats[0]);
        String med = Double.isNaN(stats[6]) ? "" : Util.myRound(stats[6]);
        String sig = Util.myRound(stats[2]);
        String surf = Coord.getUnit(stats[3], false, true) + "\u00b2";
        String min = Util.myRound(stats[4]);
        String max = Util.myRound(stats[5]);
        if (this.isWithStat() || this.isWithLabel()) {
            Color c1 = g.getColor();
            Color c2 = c1 == Color.red || c1 == Color.blue ? Color.white : null;
            Rectangle r = new Rectangle(xvLabel, yvLabel, 150, 117);
            if (this.isWithLabel() || v.aladin.view.isMultiView() || this instanceof Ligne) {
                g.drawLine(r.x, r.y, r.x, r.y + 117);
                Point c = new Point(xvOrig, yvOrig);
                g.drawLine(r.x, r.y + 58, c.x, c.y);
                Util.fillCircle5(g, c.x, c.y);
                r.x += 2;
                r.y += 11;
                g.setFont(Aladin.BOLD);
                Util.drawStringOutline(g, "Cnt", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, cnt, r.x + 43, r.y, c1, c2);
                r.y += 13;
                Util.drawStringOutline(g, "Sum", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, sum, r.x + 43, r.y, c1, c2);
                r.y += 13;
                Util.drawStringOutline(g, "Sigma", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, sig, r.x + 43, r.y, c1, c2);
                r.y += 13;
                Util.drawStringOutline(g, "Min", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, min, r.x + 43, r.y, c1, c2);
                r.y += 13;
                Util.drawStringOutline(g, "Avg", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, avg, r.x + 43, r.y, c1, c2);
                r.y += 13;
                if (!Double.isNaN(stats[6])) {
                    Util.drawStringOutline(g, "Med", r.x, r.y, c1, c2);
                    Util.drawStringOutline(g, med, r.x + 43, r.y, c1, c2);
                    r.y += 13;
                }
                Util.drawStringOutline(g, "max", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, max, r.x + 43, r.y, c1, c2);
                r.y += 13;
                if (this instanceof SourceStat) {
                    Util.drawStringOutline(g, "Rad", r.x, r.y, c1, c2);
                    Util.drawStringOutline(g, Coord.getUnit(((SourceStat)this).getRadius()), r.x + 43, r.y, c1, c2);
                    r.y += 13;
                }
                Util.drawStringOutline(g, "Surf", r.x, r.y, c1, c2);
                Util.drawStringOutline(g, surf, r.x + 43, r.y, c1, c2);
                r.y += 13;
            }
        }
        if (v.pref == this.plan.aladin.calque.getPlanBase()) {
            if (!(this instanceof SourceStat) && stats[0] > 0.0) {
                this.id = "Cnt " + cnt + " / Sum " + sum + " / Sigma " + sig + " / Min " + min + " / Avg " + avg + (Double.isNaN(stats[6]) ? "" : " / Med " + med) + " / Max " + max + (this instanceof SourceStat ? " / Rad " + Coord.getUnit(((SourceStat)this).getRadius()) : "") + " / Surf " + surf;
            }
            this.histOn();
        }
    }
}

